#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Live Code With Friends_RingsMod01.fsh  by   blackle
//https://www.shadertoy.com/view/3d2yWy
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//CC0 1.0 Universal https://creativecommons.org/publicdomain/zero/1.0/
//To the extent possible under law, Blackle Mori has waived all copyright and related or neighboring rights to this work.

float hash(float a, float b) {
  return fract(sin(dot(vec2(a,b), vec2(12.9898, 78.233))) * 43758.5453)*2.-1.;
}

float id;
float scene(vec3 p) {
  float xscale = 1.;
  id = floor(p.x*xscale);
  p.x = (fract(p.x*xscale)-0.5)/xscale;
  
  float m1 = hash(id, 69.);
  float m2 = hash(id, 38.);
  float m3 = hash(id, 41.);
  float myTime = iTime + m3*10.;
  p.yz += vec2(m1,m2)*0.2 * sin(myTime*2.);
  
  return 0.8*(length(vec2(length(p.yz)-0.5, p.x))-0.1);
}

vec3 norm(vec3 p) {
  mat3 k = mat3(p,p,p)-mat3(0.001);
  return normalize(scene(p) - vec3(scene(k[0]), scene(k[1]), scene(k[2])));
}

vec3 srgb(float a, float b, float c) {
  return pow(vec3(a,b,c), vec3(2.));
}

vec3 erot(vec3 p, vec3 ax, float ro) {
  return mix(dot(ax,p)*ax, p, cos(ro)) + sin(ro)*cross(ax,p);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  vec2 uv = (fragCoord.xy - 0.5*iResolution.xy)/iResolution.y;
  
  float n1 = hash(hash(uv.x, uv.y), iTime * 11.);
  float n2 = hash(hash(uv.x, uv.y), iTime * 23.);
  uv += vec2(n1,n2)*0.001;

  vec3 cam = normalize(vec3(1, uv));
  float rot = iTime;
  float shift = iTime;
  float outside = smoothstep(0.0,0.5, asin(sin(iTime*acos(-1.)/4.)));
  float look = mix(0.05, 0.4, outside);
  vec3 init = vec3(shift,0,0) + vec3(0, sin(rot), cos(rot))*mix(0.15, 1., outside);
  cam = erot(cam, vec3(0,1,0), cos(rot)*look);
  cam = erot(cam, vec3(0,0,1), -sin(rot)*look);
  vec3 p = init;
  bool hit = false;
  float mini = 100000.;
  int i;
  for (i = 0 ; i < 100 && !hit; i++) {
    float dist = scene(p);
    mini = min(dist, mini);
    hit = dist*dist < 1e-6;
    p+=dist*cam;
  }
  float glow = pow(exp(-mini*20.), 2.);
  float idloc = id;
  float fog = (float(i)/100.);
  vec3 n = norm(p);
  vec3 r = reflect(cam, n);
  float diff = length(sin(n*2.)*0.5+0.5)/sqrt(3.);
  float spec = length(sin(r*2.)*0.5+0.5)/sqrt(3.);
  vec3 col = mix(srgb(0.4,0.1,0.2), srgb(0.9,0.7,0.4), spec);
  col = abs(erot(col, normalize(vec3(1,7,1)), idloc)) + pow(spec, 15.)*2.;
  vec3 bg = mix(srgb(0.5, 0.2, 0.3), srgb(0.2, 0.1, 0.3), sqrt(length(uv))) + glow*0.2;
  fragColor.xyz = hit ? mix(col, bg, fog) : bg;
  fragColor.xyz = sqrt(fragColor.xyz) + hash(hash(uv.x, uv.y), iTime)*0.04;
  
  fragColor.xyz = smoothstep(vec3(-0.1), vec3(1.1), fragColor.xyz);
//  fragColor = vec4(fragColor, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
//gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb );
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

